from IO.CageViewer import CageViewer
from IO.EthoVision import EthoVision
import glob
import os.path
import logging
import pandas as pd


def loadSession(path):
    matFiles = []
    for f in glob.glob(os.path.join(path, '*.mat')):
        try:
            logging.debug('Processing %s ...', f)
            matFiles.append(CageViewer(f, roundTimeIndex=False, parseFileName = '(?P<Phase>[A-Z\d]+)_(?P<Session>[A-Z\d]+)_(?P<MouseID>[A-Z\d]+)\.mat'))
        except Exception as e:
            logging.error('Loading %s failed! %s', f, e)

    ethoVisionFiles = []
    for f in glob.glob(os.path.join(path, '*.txt')):
        try:
            logging.debug('Processing %s ...', f)
            ethoVisionFiles.append(EthoVision(f))
        except Exception as e:
            logging.error('Loading %s failed! %s', f, e)

    logging.debug('Joining Data into Session Table ...')
    Table = pd.DataFrame()
    for m in matFiles:
        try:
            #Find the matching ethovision file for this mouse
            e = None
            for i, f in enumerate(ethoVisionFiles):
                if m.meta['MouseID'] == f.meta['MouseID']:
                    e = f
                    ethoVisionFiles.pop(i)

            if e is None:
                logging.warning('Cannot find EthoVision file for mouse %s', m.meta['MouseID'])
                pTable = m.data
            else:
                logging.debug('Joining data for Mouse %s ...', m.meta['MouseID'])
                pTable = m.generateEssayTable(e)

            Table = pd.concat([Table, pTable], axis=0)
        except Exception as e:
            logging.error('Failed to load data for mouse %s. Error %s', m.meta['MouseID'], e)

    logging.debug('Finished generating Session Table for %d Mice!', len(matFiles))
    return Table
